<?php
/**
 * Customer Feedback to Notion Uninstall
 *
 * Removes all plugin data from the database when the plugin is uninstalled.
 *
 * @package CustomerFeedbackToNotion
 */

// Exit if accessed directly or if uninstall not called from WordPress
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Security check: make sure we're being called from WP
if (!defined('ABSPATH')) {
    exit;
}

global $wpdb;

// Define table name
$table_name = $wpdb->prefix . 'customer_feedback_notion';

// Drop the custom table
$wpdb->query("DROP TABLE IF EXISTS `{$table_name}`");

// Remove all plugin options
$options_to_delete = array(
    'cftn_notion_token',
    'cftn_notion_database_id',
    'cftn_last_notion_error',
    'cftn_success_message',
    'cftn_redirect_to_google_review',
    'cftn_google_review_url',
    'cftn_redirect_delay',
    'cftn_email_subject',
    'cftn_email_body',
    'cftn_token_expiry_days'
);

foreach ($options_to_delete as $option) {
    delete_option($option);
}

// Remove all feedback tokens (they start with cftn_token_)
$wpdb->query(
    "DELETE FROM {$wpdb->options} WHERE option_name LIKE 'cftn_token_%'"
);

// Remove all rate limit transients
$wpdb->query(
    "DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_cftn_rate_limit_%' OR option_name LIKE '_transient_timeout_cftn_rate_limit_%'"
);

// Clear the scheduled cron event
wp_clear_scheduled_hook('cftn_cleanup_expired_tokens');

// Optional: Log the uninstall (only if WP_DEBUG is enabled)
if (defined('WP_DEBUG') && WP_DEBUG) {
    error_log('Customer Feedback to Notion: Plugin data cleaned up during uninstall');
}