jQuery(document).ready(function($) {
    $('#customer-feedback-form').on('submit', function(e) {
        e.preventDefault();
        
        var $form = $(this);
        var $button = $form.find('button[type="submit"]');
        var $message = $('#cftn-message');
        
        var buyingProcess = $('input[name="buying_process"]:checked').val();
        var pageRating = $('input[name="page_rating"]:checked').val();
        var speedRating = $('input[name="speed_rating"]:checked').val();
        
        if (!buyingProcess || !pageRating || !speedRating) {
            $message.html('<div class="cftn-error">Please rate all categories before submitting.</div>');
            return;
        }
        
        $button.prop('disabled', true).text('Submitting...');
        $message.empty();
        
        var formData = {
            action: 'submit_customer_feedback',
            nonce: cftn_ajax.nonce,
            feedback_token: $('input[name="feedback_token"]').val(),
            buying_process: buyingProcess,
            page_rating: pageRating,
            speed_rating: speedRating,
            additional_comments: $('textarea[name="additional_comments"]').val()
        };
        
        $.post(cftn_ajax.ajax_url, formData, function(response) {
            if (response.success) {
                $message.html('<div class="cftn-success">Thank you for your feedback!</div>');
                $form.hide();
            } else {
                $message.html('<div class="cftn-error">Error: ' + response.data + '</div>');
                $button.prop('disabled', false).text('Submit Feedback');
            }
        }).fail(function() {
            $message.html('<div class="cftn-error">Connection error. Please try again.</div>');
            $button.prop('disabled', false).text('Submit Feedback');
        });
    });
    
    $('.cftn-rating input[type="radio"]').on('change', function() {
        var $rating = $(this).closest('.cftn-rating');
        var value = parseInt($(this).val());
        
        $rating.find('label').removeClass('active');
        $rating.find('input[type="radio"]').each(function(index) {
            if (index + 1 <= value) {
                $(this).next('label').addClass('active');
            }
        });
    });
});