jQuery(document).ready(function($) {
    // Star rating functionality
    $(".cftn-rating label").on("click", function(e) {
        e.preventDefault();

        var $label = $(this);
        var $input = $label.prev("input[type='radio']");

        if ($input.length === 0) {
            return;
        }

        var rating = parseInt($input.val());
        var name = $input.attr("name");
        var $ratingContainer = $label.parent();

        // Check the radio button
        $input.prop("checked", true);

        // Clear all stars in this rating group
        $ratingContainer.find("label").removeClass("selected").css("color", "#ddd");

        // Highlight selected rating and all previous stars
        $ratingContainer.find("input[type='radio']").each(function() {
            var currentRating = parseInt($(this).val());
            var $currentLabel = $(this).next("label");

            if (currentRating <= rating) {
                $currentLabel.addClass("selected").css("color", "#ffc107");
            }
        });
    });

    // Hover effects for stars
    $(".cftn-rating label").on("mouseenter", function() {
        var $label = $(this);
        var $input = $label.prev("input[type='radio']");

        if ($input.length === 0) return;

        var rating = parseInt($input.val());
        var $ratingContainer = $label.parent();

        // Temporarily highlight stars up to hovered one
        $ratingContainer.find("input[type='radio']").each(function() {
            var currentRating = parseInt($(this).val());
            var $currentLabel = $(this).next("label");

            if (currentRating <= rating) {
                $currentLabel.css("color", "#ffb400");
            } else {
                if (!$currentLabel.hasClass("selected")) {
                    $currentLabel.css("color", "#ddd");
                }
            }
        });
    });

    $(".cftn-rating").on("mouseleave", function() {
        // Restore selected state colors
        $(this).find("input[type='radio']").each(function() {
            var $label = $(this).next("label");
            if ($label.hasClass("selected")) {
                $label.css("color", "#ffc107");
            } else {
                $label.css("color", "#ddd");
            }
        });
    });

    // Form submission
    $("#customer-feedback-form").on("submit", function(e) {
        e.preventDefault();

        // Validate that all ratings are selected
        var buyingProcess = $("input[name=buying_process]:checked").val();
        var pageRating = $("input[name=page_rating]:checked").val();
        var speedRating = $("input[name=speed_rating]:checked").val();

        if (!buyingProcess || !pageRating || !speedRating) {
            $("#cftn-message").html("<p style='color: red;'>Please rate all aspects before submitting.</p>");
            return;
        }

        var formData = {
            action: "submit_customer_feedback",
            nonce: cftn_ajax.nonce,
            feedback_token: cftn_ajax.feedback_token,
            buying_process: buyingProcess,
            page_rating: pageRating,
            speed_rating: speedRating,
            additional_comments: $("#additional_comments").val()
        };

        // Show loading state
        $("#cftn-message").html("<p style='color: blue;'>Submitting feedback...</p>");

        $.ajax({
            url: cftn_ajax.ajax_url,
            type: "POST",
            data: formData,
            success: function(response) {
                if (response.success) {
                    var data = response.data;

                    // Handle both old (string) and new (object) response formats
                    var message = typeof data === 'string' ? data : data.message;
                    var redirectEnabled = data.redirect_enabled || false;
                    var redirectUrl = data.redirect_url || '';
                    var redirectDelay = parseInt(data.redirect_delay) || 3;

                    // Show success message
                    var messageHtml = "<div style='color: green; padding: 15px; background: #d4edda; border: 1px solid #c3e6cb; border-radius: 4px; margin-top: 20px;'>" + message;

                    // Add redirect countdown if enabled
                    if (redirectEnabled && redirectUrl) {
                        messageHtml += "<div id='redirect-countdown' style='margin-top: 15px; padding-top: 15px; border-top: 1px solid #c3e6cb;'>" +
                                      "Redirecting to Google Reviews in <strong id='countdown-timer'>" + redirectDelay + "</strong> seconds...</div>";
                    }

                    messageHtml += "</div>";
                    $("#cftn-message").html(messageHtml);

                    // Hide form
                    $("#customer-feedback-form").slideUp();
                    $(".cftn-rating label").removeClass("selected").css("color", "#ddd");

                    // Handle redirect if enabled
                    if (redirectEnabled && redirectUrl) {
                        var countdown = redirectDelay;

                        var countdownInterval = setInterval(function() {
                            countdown--;
                            $("#countdown-timer").text(countdown);

                            if (countdown <= 0) {
                                clearInterval(countdownInterval);
                                window.location.href = redirectUrl;
                            }
                        }, 1000);
                    }
                } else {
                    $("#cftn-message").html("<p style='color: red;'>❌ Error: " + response.data + "</p>");
                }
            },
            error: function(xhr, status, error) {
                $("#cftn-message").html("<p style='color: red;'>❌ Connection error. Please try again.</p>");
            }
        });
    });
});