jQuery(document).ready(function($) {
    
    function showMessage(message, type) {
        var messageDiv = $('<div id="cftn-admin-message" class="notice notice-' + type + ' is-dismissible"><p>' + message + '</p></div>');
        $('.wrap h1').after(messageDiv);
        setTimeout(function() {
            messageDiv.fadeOut(function() {
                $(this).remove();
            });
        }, 5000);
    }
    
    $('#cftn-test-connection').on('click', function(e) {
        e.preventDefault();
        
        var button = $(this);
        var originalText = button.text();
        
        button.text('Testing...').prop('disabled', true);
        
        $.ajax({
            url: cftn_admin_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'cftn_test_notion_connection',
                nonce: cftn_admin_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    showMessage(response.data, 'success');
                } else {
                    showMessage(response.data, 'error');
                }
            },
            error: function() {
                showMessage('Connection test failed. Please try again.', 'error');
            },
            complete: function() {
                button.text(originalText).prop('disabled', false);
            }
        });
    });
    
    $('#cftn-sync-data').on('click', function(e) {
        e.preventDefault();
        
        var button = $(this);
        var originalText = button.text();
        
        button.text('Syncing...').prop('disabled', true);
        
        $.ajax({
            url: cftn_admin_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'cftn_sync_feedback_data',
                nonce: cftn_admin_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    showMessage(response.data, 'success');
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    showMessage(response.data, 'error');
                }
            },
            error: function() {
                showMessage('Sync failed. Please try again.', 'error');
            },
            complete: function() {
                button.text(originalText).prop('disabled', false);
            }
        });
    });
    
    $('.cftn-comment').on('click', function() {
        var fullComment = $(this).attr('title');
        if (fullComment && fullComment.length > 50) {
            alert(fullComment);
        }
    });
    
    $('.cftn-bar').each(function() {
        var width = $(this).css('width');
        $(this).css('width', '0').animate({width: width}, 1000);
    });
    
    $('.cftn-trend-bar').each(function(index) {
        var height = $(this).css('height');
        $(this).css('height', '2px').delay(index * 100).animate({height: height}, 800);
    });
    
    if ($('.cftn-feedback-table table').length > 0) {
        $('.cftn-feedback-table table').on('click', 'tr', function() {
            $(this).toggleClass('selected');
        });
    }
    
});