# Customer Feedback to Notion

**Version:** 1.0.3
**Author:** Istvan Barcza
**Website:** [COOD3](https://cood3.com/en/cftn/)

## Description

Customer Feedback to Notion is a WordPress/WooCommerce plugin that collects customer feedback after purchase and sends data to your Notion database. The plugin captures ratings for the buying process, page quality, and website speed, along with optional comments.

## Features

- **Automated Feedback Requests**: Automatically sends feedback emails when WooCommerce orders are completed
- **Token-Based Security**: Secure, time-limited feedback links with customizable expiration (1-30 days)
- **Notion Integration**: Seamless synchronization with your Notion database
- **Customizable Emails**: Customize email subject, body, and use placeholders for personalization
- **Google Review Integration**: Optional redirect to Google Business review page after feedback submission
- **Rate Limiting**: Protection against spam with configurable submission limits
- **Analytics Dashboard**: View feedback statistics, ratings breakdown, and monthly trends
- **AJAX-Powered Forms**: Smooth user experience with no page reloads
- **Multi-language Ready**: Translation-ready with text domain support

## Download

**[Download Plugin v1.0.3](https://cood3.com/wp-content/uploads/2025/09/cftn_103.zip)**

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- WooCommerce 3.0 or higher
- A Notion account with API access

## Installation

1. **Download** the plugin from the link above
2. **Upload** the plugin folder to `/wp-content/plugins/`
3. **Activate** the plugin through the 'Plugins' menu in WordPress
4. **Configure** the plugin settings (see Configuration section below)

## Configuration

### Step 1: Create a Notion Integration

1. Go to [https://www.notion.so/my-integrations](https://www.notion.so/my-integrations)
2. Click "New integration"
3. Name your integration (e.g., "WooCommerce Feedback")
4. Copy the **Internal Integration Token**

### Step 2: Create a Notion Database

Create a new database in Notion with the following properties (names and types must match exactly):

| Property Name | Property Type | Required |
|--------------|--------------|----------|
| `Name` | Title | ✅ Yes (default title field) |
| `Customer Name` | Text | ✅ Yes |
| `Email` | Email | ✅ Yes |
| `Order ID` | Number | ✅ Yes |
| `Buying Process Rating` | Number | ✅ Yes |
| `Page Rating` | Number | ✅ Yes |
| `Speed Rating` | Number | ✅ Yes |
| `Submitted Date` | Date | ✅ Yes |
| `Comments` | Text | ⚪ Optional |

**Important:** Property names are case-sensitive and must match exactly (including spaces).

### Step 3: Share Database with Integration

1. Open your Notion database
2. Click the "..." menu in the top right
3. Select "Connections"
4. Add your integration

### Step 4: Get Database ID

Copy the database ID from the URL. The ID is the part after your workspace name and before the "?":

```
https://www.notion.so/myworkspace/a1b2c3d4e5f6?v=...
                                 ↑ This is your Database ID
```

### Step 5: Configure Plugin Settings

1. Go to **WordPress Admin → Feedback to Notion → Settings**
2. Enter your **Notion API Token**
3. Enter your **Notion Database ID**
4. Customize email settings (optional)
5. Configure Google Review integration (optional)
6. Click **Save Changes**
7. Use the **Test Connection** button on the Dashboard to verify setup

## Usage

### Automatic Feedback Collection

Once configured, the plugin automatically:
1. Sends a feedback email when a WooCommerce order is marked as "Completed"
2. Generates a secure, time-limited feedback link
3. Collects customer ratings and comments through the feedback form
4. Syncs feedback data to your Notion database

### Manual Sync

If some feedback entries fail to sync automatically:
1. Go to **Feedback to Notion → Dashboard**
2. Click **Sync Unsynced Data**
3. Review sync results

### Email Customization

Customize feedback request emails using placeholders:

- `{customer_name}` - Customer first name
- `{order_number}` - Order number
- `{feedback_url}` - Feedback form link
- `{expiry_days}` - Number of days until link expires

Example:
```
Hi {customer_name},

Thank you for your recent order #{order_number}!

We'd love to hear about your shopping experience:
{feedback_url}

This link will expire in {expiry_days} days.
```

### Google Review Integration

Enable optional redirect to Google Business review page:

1. Go to **Settings → Google Review Integration**
2. Enable **Redirect to Google Review**
3. Enter your Google Business review URL (e.g., `https://g.page/r/.../review`)
4. Set redirect delay (0-30 seconds)

Customers will be redirected after submitting feedback.

## Admin Pages

### Dashboard
- View feedback statistics (total, monthly, average rating)
- Check Notion sync status
- Test Notion connection
- View recent feedback submissions

### Settings
- Configure Notion API credentials
- Customize email templates
- Set feedback link expiration
- Configure Google Review integration

### Analytics
- View rating breakdowns for each category
- Monitor monthly feedback trends
- Analyze customer satisfaction patterns

## Security Features

- **Nonce Verification**: All AJAX requests are protected with WordPress nonces
- **Rate Limiting**: Prevents spam submissions (max 3 submissions per IP in 5 minutes)
- **Token Expiration**: Feedback links expire after configurable period (1-30 days)
- **Input Validation**: All user inputs are sanitized and validated
- **URL Whitelisting**: Google Review URLs are validated against allowed domains
- **Content Security Policy**: Applied to feedback pages for enhanced security
- **Capability Checks**: Admin functions require appropriate user permissions

## Database

The plugin creates a custom table `wp_customer_feedback_notion` with the following schema:

- `id` - Unique feedback ID
- `order_id` - WooCommerce order ID
- `customer_email` - Customer email address
- `customer_name` - Customer full name
- `buying_process_rating` - Rating (1-5)
- `page_rating` - Rating (1-5)
- `speed_rating` - Rating (1-5)
- `additional_comments` - Optional text
- `submitted_at` - Timestamp
- `notion_synced` - Sync status (0/1)
- `notion_page_id` - Notion page ID

## Scheduled Tasks

The plugin schedules a daily cleanup task to remove expired feedback tokens and rate limit data.

## Support

- **Documentation**: [https://cood3.com/en/cftn_documentation](https://cood3.com/en/cftn_documentation)
- **Support**: [https://cood3.com/en/cftn_documentation/#support](https://cood3.com/en/cftn_documentation/#support)
- **Plugin Homepage**: [https://cood3.com/en/cftn/](https://cood3.com/en/cftn/)

## Troubleshooting

### Feedback not syncing to Notion

1. Check the **Last Notion Sync Error** on the Dashboard
2. Click **Test Notion Connection** to verify credentials
3. Ensure database schema matches requirements (see Configuration)
4. Check that the database is shared with your integration
5. Use **Sync Unsynced Data** to manually retry failed syncs

### Emails not sending

1. Verify your WordPress mail configuration
2. Check spam/junk folders
3. Test with a plugin like WP Mail SMTP
4. Ensure WooCommerce order status changes to "Completed"

### Feedback link expired

1. Increase **Feedback Link Expiry (Days)** in Settings
2. Send a new feedback request manually from WooCommerce order

## Changelog

### Version 1.0.3
- Enhanced security with rate limiting
- Improved error handling and user feedback
- Added database schema validation
- Improved redirect handling
- Added comprehensive admin documentation

### Version 1.0.2
- Added Google Review integration
- Customizable email templates
- Token expiration settings
- Enhanced analytics page

### Version 1.0.1
- Bug fixes and performance improvements
- Added security headers
- Improved Notion API error messages

### Version 1.0.0
- Initial release
- Core feedback collection functionality
- Notion integration
- Analytics dashboard

## License

This plugin is proprietary software developed by Istvan Barcza / COOD3.

## Credits

Developed by **Istvan Barcza**
Website: [COOD3.com](https://cood3.com/)
